/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.ShellLimitType;
import oracle.cluster.verification.ShellResourceType;
import oracle.cluster.verification.ShellType;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.fixup.FixupData;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sTaskShellLimits;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskShellLimits
extends Task {
    private String m_constraintName = null;
    private ShellLimitType m_limitType;
    private ShellResourceType m_resourceType;
    private String ULIMIT_USER_NAME = null;
    private List<ShellLimitData> m_shellLimitList = null;
    private HashMap<String, ShellType> m_nodeLoginShellMap = new HashMap();
    private Hashtable<String, Long> m_nodeExpectedLimitTable = null;
    private List<String> m_loginShellRetrievalFailedNodes = new ArrayList<String>();
    String ULIMIT_SOFTLIMIT_FILES = "SOFT_FILES";
    String ULIMIT_SOFTLIMIT_PROCESS = "SOFT_PROCESS";
    String ULIMIT_HARDLIMIT_FILES = "HARD_FILES";
    String ULIMIT_HARDLIMIT_PROCESS = "HARD_PROCESS";
    String ULIMIT_USER_ATTR = "USER";

    public TaskShellLimits(ShellType shellType, ShellResourceType resourceType, ShellLimitType limitType, long limit) {
        this.m_shellLimitList = new ArrayList<ShellLimitData>();
        this.m_shellLimitList.add(new ShellLimitData(shellType, limit, SeverityType.CRITICAL));
        this.init(limitType, resourceType);
    }

    public TaskShellLimits(List<ShellLimitData> shellLimitsList, ShellLimitType limitType, ShellResourceType resourceType) {
        this.m_shellLimitList = shellLimitsList;
        this.init(limitType, resourceType);
    }

    private void init(ShellLimitType limitType, ShellResourceType resourceType) {
        this.m_resourceType = resourceType;
        this.m_limitType = limitType;
        this.ULIMIT_USER_NAME = System.getProperty("user.name");
        this.m_constraintName = ShellLimitType.HARD.equals((Object)this.m_limitType) ? s_msgBundle.getMessage("1067", false) : s_msgBundle.getMessage("1068", false);
    }

    @Override
    public String getDefaultElementName() {
        if (ShellLimitType.HARD.equals((Object)this.m_limitType)) {
            return s_msgBundle.getMessage("4419", false) + ": " + (Object)((Object)this.m_resourceType);
        }
        return s_msgBundle.getMessage("4443", false) + ": " + (Object)((Object)this.m_resourceType);
    }

    @Override
    public boolean performTask() {
        String[] participatingNodeList;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Performing shell limit verification task... ");
        }
        if (!VerificationUtil.getCurrentOS().toLowerCase().startsWith("linux")) {
            this.setRebootRequiredForFixup(true);
        }
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{this.m_constraintName, this.m_resourceType.toString()}));
        if (this.m_nodeExpectedLimitTable == null) {
            this.m_nodeExpectedLimitTable = new Hashtable();
            this.m_nodeLoginShellMap.clear();
            ShellLimitData data = this.m_shellLimitList.get(0);
            for (String node : this.m_nodeList) {
                this.m_nodeExpectedLimitTable.put(node, data.getExpectedValue());
                this.m_nodeLoginShellMap.put(node, data.getShell());
            }
        }
        if ((participatingNodeList = this.m_nodeExpectedLimitTable.keySet().toArray(new String[0])) != null && participatingNodeList.length > 0) {
            this.performShellLimitChecks(participatingNodeList);
        }
        if (this.m_resultSet.allSuccess()) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"Successful on all nodes. Retruning true");
            }
            ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{this.m_constraintName, this.m_resourceType.toString()}));
            return true;
        }
        if (this.m_loginShellRetrievalFailedNodes.size() > 0) {
            String errMsg = s_gMsgBundle.getMessage("0341", true, (Object[])new String[]{VerificationUtil.strCollection2String(this.m_loginShellRetrievalFailedNodes)});
            ReportUtil.printError(errMsg);
            ErrorDescription errDec = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDec);
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"Atleast on one node failed. Returning fail");
        }
        ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{this.m_constraintName, this.m_resourceType.toString()}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    private void performShellLimitChecks(String[] participatingNodeList) {
        FixupData fixupData = null;
        if (this.isFixupReqd() && sTaskShellLimits.isLimitFixable(this.m_resourceType, this.m_limitType)) {
            fixupData = new FixupData(null);
        }
        if (this.isLoginShellConsistent()) {
            ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.SHELL_LIMIT_TYPE, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.STATUS);
        } else {
            ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.LOGIN_SHELL, ReportUtil.SHELL_LIMIT_TYPE, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.STATUS);
        }
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet limitChkRS = new ResultSet();
        Object limitOutput = null;
        globalExec.getRLimit(participatingNodeList, this.ULIMIT_USER_NAME, this.m_limitType.toString().toLowerCase(), this.m_resourceType.getItemName(), limitChkRS);
        this.m_resultSet.uploadResultSet(limitChkRS);
        Hashtable t = limitChkRS.getResultTable();
        for (String node : participatingNodeList) {
            String nstatus;
            double shellLimitOnNode;
            Result result = (Result)t.get(node);
            long expectedLimitOnNode = this.m_nodeExpectedLimitTable.get(node);
            if (result.getStatus() != 1) {
                Object[] msgParams = new String[]{this.m_resourceType.toString(), node};
                String errMsg = null;
                errMsg = this.m_limitType.equals((Object)ShellLimitType.SOFT) ? s_msgBundle.getMessage("4355", false, msgParams) : s_msgBundle.getMessage("4356", false, msgParams);
                this.m_resultSet.addResult(node, 2);
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
                continue;
            }
            String shellLimitOnNodeStr = (String)result.getResultInfoSet().firstElement();
            if ("unlimited".equals(shellLimitOnNodeStr)) {
                shellLimitOnNode = Double.MAX_VALUE;
            } else {
                shellLimitOnNode = VerificationUtil.parseStringToNumber(shellLimitOnNodeStr);
                shellLimitOnNodeStr = VerificationUtil.parseObjectToString(shellLimitOnNode);
            }
            this.m_resultSet.getResult(node).setHasResultValues(true);
            this.m_resultSet.getResult(node).setExpectedValue(Long.toString(expectedLimitOnNode));
            this.m_resultSet.getResult(node).setActualValue(shellLimitOnNodeStr);
            if (shellLimitOnNode >= (double)expectedLimitOnNode) {
                Trace.out((String)("Sufficient shell limit on node: " + node + ", shell resource type = " + (Object)((Object)this.m_resourceType) + ", shell limit type = " + (Object)((Object)this.m_limitType) + " [Required=" + expectedLimitOnNode + ", Available=" + shellLimitOnNode + "]"));
                nstatus = ReportUtil.PASSED;
            } else {
                Trace.out((String)("Insufficient shell limit on node: " + node + ", shell resource type = " + (Object)((Object)this.m_resourceType) + ", shell limit type = " + (Object)((Object)this.m_limitType) + " [Required=" + expectedLimitOnNode + ", Available=" + shellLimitOnNode + "]"));
                String errorMessage = null;
                String cause = null;
                String action = null;
                if (this.m_limitType.equals((Object)ShellLimitType.SOFT)) {
                    errorMessage = s_msgBundle.getMessage("4353", true, (Object[])new String[]{this.m_resourceType.toString(), node, Long.toString(expectedLimitOnNode), shellLimitOnNodeStr});
                    cause = s_msgBundle.getCause("4353", false);
                    action = s_msgBundle.getAction("4353", false);
                } else {
                    errorMessage = s_msgBundle.getMessage("4354", true, (Object[])new String[]{this.m_resourceType.toString(), node, Long.toString(expectedLimitOnNode), shellLimitOnNodeStr});
                    cause = s_msgBundle.getCause("4354", false);
                    action = s_msgBundle.getAction("4354", false);
                }
                ErrorDescription errDesc = new ErrorDescription(errorMessage, cause, action);
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                this.m_resultSet.addResult(node, 3);
                nstatus = ReportUtil.FAILED;
                if (null != fixupData) {
                    Trace.out((String)("Generating fixup data for shell limit (" + (Object)((Object)this.m_resourceType) + ") on node '" + node + "'"));
                    VerificationLogData.logInfo("Generating fixup data for shell limit (" + (Object)((Object)this.m_resourceType) + ") on node '" + node + "'");
                    fixupData.addParticipatingNode(node);
                    fixupData.setActualValue(node, shellLimitOnNodeStr);
                    fixupData.setExpectedValue(node, Long.toString(expectedLimitOnNode));
                }
            }
            if (null != fixupData && fixupData.getParticipatingNodes().size() > 0) {
                Trace.out((String)("Adding the generated fixup data for shell limit (" + (Object)((Object)this.m_resourceType) + ")"));
                VerificationLogData.logInfo("Adding the generated fixup data for shell limit (" + (Object)((Object)this.m_resourceType) + ")");
                String chkType = "";
                if (this.m_limitType.equals((Object)ShellLimitType.SOFT)) {
                    if (this.m_resourceType.equals((Object)ShellResourceType.MAX_FILEDESC)) {
                        chkType = this.ULIMIT_SOFTLIMIT_FILES;
                    } else if (this.m_resourceType.equals((Object)ShellResourceType.MAX_PROC)) {
                        chkType = this.ULIMIT_SOFTLIMIT_PROCESS;
                    }
                } else if (this.m_resourceType.equals((Object)ShellResourceType.MAX_FILEDESC)) {
                    chkType = this.ULIMIT_HARDLIMIT_FILES;
                } else if (this.m_resourceType.equals((Object)ShellResourceType.MAX_PROC)) {
                    chkType = this.ULIMIT_HARDLIMIT_PROCESS;
                }
                fixupData.addFixupInstruction(this.ULIMIT_USER_ATTR, this.ULIMIT_USER_NAME);
                fixupData.addFixupInstruction(chkType, Long.toString(expectedLimitOnNode));
                this.setFixupData(fixupData);
            }
            String limitTypeText = null;
            limitTypeText = this.m_limitType.equals((Object)ShellLimitType.SOFT) ? s_msgBundle.getMessage("8219", false) : s_msgBundle.getMessage("8220", false);
            if (this.isLoginShellConsistent()) {
                ReportUtil.writeRecord(node, limitTypeText, shellLimitOnNodeStr, Long.toString(expectedLimitOnNode), nstatus);
                continue;
            }
            ReportUtil.writeRecord(node, this.m_nodeLoginShellMap.get(node).toString(), limitTypeText, shellLimitOnNodeStr, Long.toString(expectedLimitOnNode), nstatus);
        }
        for (String node : this.m_loginShellRetrievalFailedNodes) {
            if (this.isLoginShellConsistent()) {
                ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, ReportUtil.UNKNOWN, ReportUtil.UNKNOWN, ReportUtil.FAILED);
                continue;
            }
            ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, ReportUtil.UNKNOWN, ReportUtil.UNKNOWN, ReportUtil.UNKNOWN, ReportUtil.FAILED);
        }
    }

    public boolean hasNodesWithApplicableLoginShell() {
        this.retrieveLoginShell();
        if (this.m_resultSet.anyFailure()) {
            return true;
        }
        return this.m_nodeExpectedLimitTable.size() > 0;
    }

    private void retrieveLoginShell() {
        Trace.out((String)("Retrieving login shell from nodes " + VerificationUtil.strArr2List(this.m_nodeList)));
        ResultSet loginShellResultSet = new ResultSet();
        if (this.m_nodeLoginShellMap.size() == 0 && this.m_nodeList != null && this.m_nodeList.length > 0) {
            GlobalExecution globalExec = new GlobalExecution();
            this.m_nodeLoginShellMap = new HashMap();
            globalExec.getLoginShell(this.m_nodeList, loginShellResultSet);
            Hashtable ht = loginShellResultSet.getResultTable();
            Enumeration e = ht.keys();
            while (e.hasMoreElements()) {
                ShellType loginShell = null;
                String node = (String)e.nextElement();
                Result nodeResult = (Result)ht.get(node);
                if (nodeResult.getStatus() == 1) {
                    String[] shellPathArr;
                    String loginShellPath = (String)nodeResult.getResultInfoSet().firstElement();
                    String loginShellStr = null;
                    if (VerificationUtil.isStringGood(loginShellPath) && VerificationUtil.isStringGood(loginShellStr = (shellPathArr = loginShellPath.split(File.separator))[shellPathArr.length - 1].toUpperCase())) {
                        loginShellStr = loginShellStr.trim();
                    }
                    try {
                        Trace.out((String)("The login shell on node " + node + " is " + loginShellStr));
                        VerificationLogData.logInfo("The login shell on node " + node + " is " + loginShellStr);
                        loginShell = TaskShellLimits.getShellType(loginShellStr);
                        this.m_nodeLoginShellMap.put(node, loginShell);
                    }
                    catch (VerificationException ve) {
                        Trace.out((String)("The login shell could not be retrieved from node " + node));
                        VerificationLogData.logError("The login shell could not be retrieved from node " + node);
                        Trace.out((String)ve.getMessage());
                        String errMsg = s_gMsgBundle.getMessage("0341", true, (Object[])new String[]{node});
                        errMsg = errMsg + VerificationConstants.LINE_SEPARATOR + ve.getMessage();
                        ErrorDescription errDesc = new ErrorDescription(errMsg);
                        nodeResult.addErrorDescription(errDesc);
                        nodeResult.setStatus(2);
                        this.m_loginShellRetrievalFailedNodes.add(node);
                    }
                    continue;
                }
                String errMsg = s_gMsgBundle.getMessage("0341", true, (Object[])new String[]{node});
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                nodeResult.addErrorDescription(errDesc);
                nodeResult.setStatus(2);
                this.m_loginShellRetrievalFailedNodes.add(node);
                Trace.out((String)("The login shell could not be retrieved from node " + node));
                VerificationLogData.logError("The login shell could not be retrieved from node " + node);
            }
        }
        this.m_nodeExpectedLimitTable = new Hashtable();
        for (String node : this.m_nodeLoginShellMap.keySet()) {
            ShellLimitData data = this.getLimitForNode(node);
            if (data == null) continue;
            this.m_nodeExpectedLimitTable.put(node, data.getExpectedValue());
        }
        ArrayList<String> nodeListForTask = new ArrayList<String>();
        for (String node : this.m_nodeList) {
            Result nodeRslt = loginShellResultSet.getResult(node);
            if (nodeRslt.getStatus() == 1) {
                if (!this.m_nodeExpectedLimitTable.containsKey(node)) continue;
                nodeListForTask.add(node);
                this.m_resultSet.addResult(node, nodeRslt);
                continue;
            }
            this.m_resultSet.addResult(node, nodeRslt);
            nodeListForTask.add(node);
        }
        if (nodeListForTask.size() > 0) {
            this.setNodeList(nodeListForTask.toArray(new String[0]));
        }
        this.setSeverity();
    }

    private boolean isLoginShellConsistent() {
        boolean isConsistent = true;
        ShellType refShell = null;
        for (String node : this.m_nodeLoginShellMap.keySet()) {
            ShellType nodeShell = this.m_nodeLoginShellMap.get(node);
            if (refShell == null) {
                refShell = nodeShell;
            }
            if (nodeShell == refShell) continue;
            isConsistent = false;
            break;
        }
        return isConsistent;
    }

    private void setSeverity() {
        SeverityType type = SeverityType.CRITICAL;
        boolean isIgnorable = true;
        for (String node : this.m_nodeLoginShellMap.keySet()) {
            if (this.getLimitForNode(node) == null || this.getLimitForNode(node).getSeverity() != SeverityType.CRITICAL) continue;
            isIgnorable = false;
        }
        if (isIgnorable) {
            type = SeverityType.IGNORABLE;
        }
        this.setSeverity(type);
    }

    private ShellLimitData getLimitForNode(String node) {
        ShellLimitData data = null;
        if (this.m_nodeLoginShellMap.containsKey(node)) {
            for (ShellLimitData shd : this.m_shellLimitList) {
                if (!shd.getShell().equals((Object)this.m_nodeLoginShellMap.get(node))) continue;
                data = shd;
                break;
            }
        }
        return data;
    }

    private static ShellType getShellType(String shellSel) throws VerificationException {
        if (shellSel == null) {
            Object[] msgParams = new String[]{shellSel};
            String msg = s_msgBundle.getMessage("1106", false, msgParams);
            Trace.out((String)msg);
            throw new VerificationException(msg);
        }
        if (shellSel.equals("SH")) {
            return ShellType.SH;
        }
        if (shellSel.equals("BASH")) {
            return ShellType.BASH;
        }
        if (shellSel.equals("KSH")) {
            return ShellType.KSH;
        }
        if (shellSel.equals("CSH")) {
            return ShellType.CSH;
        }
        if (shellSel.equals("TCSH")) {
            return ShellType.TCSH;
        }
        if (shellSel.equals("ZSH")) {
            return ShellType.ZSH;
        }
        Object[] msgParams = new String[]{shellSel};
        String msg = s_msgBundle.getMessage("1106", false, msgParams);
        Trace.out((String)msg);
        throw new VerificationException(msg);
    }

    @Override
    public String getDefaultDescription() {
        if (ShellLimitType.HARD.equals((Object)this.m_limitType)) {
            return s_msgBundle.getMessage("4489", false, (Object[])new String[]{this.m_resourceType.toString()});
        }
        return s_msgBundle.getMessage("4490", false, (Object[])new String[]{this.m_resourceType.toString()});
    }

    @Override
    public String getTaskID() {
        return "ShellLimits_" + (Object)((Object)this.m_limitType) + "_" + (Object)((Object)this.m_resourceType);
    }

    public static class ShellLimitData {
        private ShellType m_shellType;
        private SeverityType m_severity;
        private long m_expectedValue;

        public ShellLimitData(String shell, long expectedValue, SeverityType severity) throws VerificationException {
            this(TaskShellLimits.getShellType(shell), expectedValue, severity);
        }

        public ShellLimitData(String shell, long expectedValue) throws VerificationException {
            this(TaskShellLimits.getShellType(shell), expectedValue, null);
        }

        public ShellLimitData(ShellType shellType, long expectedValue, SeverityType severity) {
            this.m_shellType = shellType;
            this.m_expectedValue = expectedValue;
            this.m_severity = severity != null ? severity : SeverityType.CRITICAL;
        }

        public ShellLimitData(ShellType shellType, long expectedValue) {
            this(shellType, expectedValue, null);
        }

        public long getExpectedValue() {
            return this.m_expectedValue;
        }

        public ShellType getShell() {
            return this.m_shellType;
        }

        public SeverityType getSeverity() {
            return this.m_severity;
        }
    }
}

